/*

Combustion Output MacroScript File
Created:		Sept 6 2000
Author:		Fred Moreau

Revision History:
	Yann Bertaud
		changed the method for which the render element filename was retrieved. Using the new GetRenderElementFilename method. 
		re.bitmap.filename was replaced by refilename which is defined by eman.GetRenderElementfilename (e)
		
	11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products
	

*/

Macroscript CombustionOutput 
category:~COMBUSTIONOUTPUT_CATEGORY~ 
internalCategory:"File"
ButtonText:~COMBUSTIONOUTPUT_BUTTONTEXT~
tooltip:~COMBUSTIONOUTPUT_TOOLTIP~
icon:#("CWS_Output",2)
silentErrors:true
(
	SetSilentMode true											-- Set Silent Mode for BitMap Loading
	eman = maxOps.GetCurRenderElementMgr()						-- Get Current Render Elements Manager
	if (eman.NumRenderElements()) > 0 and (eman.GetElementsActive()) == true and eman.GetCombustionOutputPath() != "" then
	(
		try
		(
			re_array = #()										-- Init the RenderElements Array
			for e = 0 to (eman.NumRenderElements() - 1) do		-- For all RenderElements in REManager
			(
				re = eman.GetRenderElement e					-- Get the Element
				refilename = eman.GetRenderElementfilename (e)	-- added for 3ds max 5, use new GetRenderElementFilename method to get render element filename.
				try (re.enabled ; OkToGo = True) catch (OkToGo = False) -- Is Element Plug-In Missing
				if OkToGo then							-- If Element is not Standin
				(
					if re.enabled == true and refilename != undefined then	-- If Element Enabled
					(
						if not IsCwsImgType refilename then	-- Check combustion ImageType Compliance
						(
							Print ~OK~
							cwsMessage = ~CWSMESSAGE_WARNING_IMAGE_TYPE_NOT_SUPPORTED_IN_COMBUSTION~ +
							(re.elementName + ~ELEMENT_IS_OUTPUTTING_TO~ + (getfilenameType refilename) + ~FILES~)
							cwsWarn cwsMessage
						)
						else
						(
							if ((KindOfRenderElement re) == #Diffuse or (KindOfRenderElement re) == #Shadow or (KindOfRenderElement re) == #Atmosphere) and (findItem #(".tga", ".tif", ".rla", ".rpf", ".png") (getfilenameType refilename) == 0) then
							(
								cwsMessage = ~CWSMESSAGE_WARNING_ELEMENT_REQUIRES_ALPHA~ +
								re.elementName + ~ELEMENT_NAME_ELEMENT_IS_OUTPUTTING_TO~ + (getfilenameType refilename) + ~ELEMENT_NAME_FILES~ +
								~IT_IS_RECOMMENDED_TO_OUTPUT_DIFFUSE_SHADOWS_AND_ATMOSPHERE_ELEMENTS~
								cwsWarn cwsMessage
							)
							cwselement = relement name:re.elementName kind:(KindOfRenderElement re) file:refilename transferMode:1 Visibility:Off
							append re_array cwselement				-- Add RenderElement to the Process List
						)
					)-- end If Enabled
					else
					(
						cwsMessage = ~WARNING~ + re.elementName + ~ELEMENT_HAS_NO_BITMAP_OR_IS_DISABLED~
						cwsWarn cwsMessage
					)
				)-- end If not Standin
				else
				(
					cwsMessage = ~CWSMESSAGE_WARNING_ELEMENT_IS_USING_MISSING_DLL~
					cwsWarn cwsMessage
				)
			)-- end for loop
			if re_array.count != 0 then
			(
				RElements2cws re_array (eman.GetCombustionOutputPath())
				print ~PRINT_RENDER_ELEMENTS_HAVE_BEEN_OUTPUTTED_TO_COMBUSTION_SUCCESSFULLY~
			)-- end if
			Else
			(
				cwsMessage = ~CWSMESSAGE_NO_RENDER_ELEMENTS_TO_OUTPUT~
				cwsWarn cwsMessage
			)
		)-- end try
		catch
		(
			try (close (eman.GetCombustionOutputPath())) catch()
			cwsMessage = ~CWSMESSAGE_ERRORS_OCCURED_WHEN_OUTPUTTING_TO_COMBUSTION_FILE~
			cwsWarn cwsMessage
		)-- end catch
	)
	else
	(
			cwsMessage = ~WARNING_COMBUSTION_WORKSPACE_FILE_NOT_SET~ +
~OR_NO_RENDER_ELEMENTS_TO_OUTPUT~
			cwsWarn cwsMessage
	)
	SetSilentMode false -- Reset Silent Mode Off for BitMap Loading
)

